#include <SFML/Graphics.hpp>
#include <iostream>
#include <array>

#include "EntitySystem.h"
#include "ComponentSystem.h"

#include "RenderSystem.h"
#include "Transform.h"

int main()
{
	//Create entity system
	EntitySystem& entitySystem = EntitySystem::GetInstance();

	//Add a render system
	RenderSystem renderSystem;
	entitySystem.AddSystem(renderSystem);

	std::vector<EntityId> entityIds;
	const float moveSpeed = 100.0f;

	//Create drawable entities

	//Map entity
	EntityId mapEntity = entitySystem.AddEntity();
	{
		RenderProperties* pRenderProperties = entitySystem.AddComponent<RenderProperties>(mapEntity);
		pRenderProperties->texture.loadFromFile("./map.png");
		pRenderProperties->sprite.setTexture(pRenderProperties->texture);
		pRenderProperties->sprite.setScale(2.f, 2.f);

		TransformProperties* pTransformProperties = entitySystem.AddComponent<TransformProperties>(mapEntity);
	}

	//Paladin entity
	EntityId paladinEntity = entitySystem.AddEntity();
	{
		RenderProperties* pRenderProperties = entitySystem.AddComponent<RenderProperties>(paladinEntity);
		pRenderProperties->texture.loadFromFile("./paladin.png");
		pRenderProperties->sprite.setTexture(pRenderProperties->texture);
		pRenderProperties->sprite.setTextureRect(sf::IntRect(132, 99, 32, 32));
		pRenderProperties->sprite.setScale(2.f, 2.f);

		TransformProperties* pTransformProperties = entitySystem.AddComponent<TransformProperties>(paladinEntity);
	}

	sf::Clock clock;
	sf::Time lastFrameTime;

	while (renderSystem.GetWindow().isOpen())
	{
		//Game Loop
		sf::Time currentTime = clock.getElapsedTime();
		float deltaSeconds = (currentTime - lastFrameTime).asMicroseconds() / 1000.0f / 1000.0f;

		std::cout << deltaSeconds << "\n";

		sf::Event event;
		while (renderSystem.GetWindow().pollEvent(event))
		{
			if (event.type == sf::Event::Closed)
			{
				renderSystem.GetWindow().close();
			}
		}

		sf::Vector2f moveVector;
		if (sf::Keyboard::isKeyPressed(sf::Keyboard::W))
		{
			moveVector.y -= moveSpeed * deltaSeconds;
		}
		if (sf::Keyboard::isKeyPressed(sf::Keyboard::A))
		{
			moveVector.x -= moveSpeed * deltaSeconds;
		}
		if (sf::Keyboard::isKeyPressed(sf::Keyboard::S))
		{
			moveVector.y += moveSpeed * deltaSeconds;
		}
		if (sf::Keyboard::isKeyPressed(sf::Keyboard::D))
		{
			moveVector.x += moveSpeed * deltaSeconds;
		}

		if (TransformProperties* pProperties = entitySystem.GetComponent<TransformProperties>(paladinEntity))
		{
			pProperties->transform.translate(moveVector);
		}

		entitySystem.Update(deltaSeconds);

		if (sf::Keyboard::isKeyPressed(sf::Keyboard::Space))
		{
			if (entitySystem.HasComponent<RenderProperties>(paladinEntity))
			{
				entitySystem.RemoveComponent<RenderProperties>(paladinEntity);
			}
			else
			{
				RenderProperties* pProperties = entitySystem.AddComponent<RenderProperties>(paladinEntity);
				pProperties->texture.loadFromFile("./paladin.png");
				pProperties->sprite.setTexture(pProperties->texture);
				pProperties->sprite.setTextureRect(sf::IntRect(132, 99, 32, 32));
				pProperties->sprite.setScale(2.f, 2.f);
			}
		}

		lastFrameTime = currentTime;
	}

	return 0;
}